document.getElementById('crearEncuesta').addEventListener('submit', function(event) {
    event.preventDefault();
    guardarEncuesta();
});

function mostrarOpciones() {
    var tipoRespuesta = document.getElementById('tipoRespuesta').value;
    var rangoPuntuacion = document.getElementById('rangoPuntuacion');
    
    if (tipoRespuesta === 'puntuacion') {
        rangoPuntuacion.style.display = 'block';
    } else {
        rangoPuntuacion.style.display = 'none';
    }
}

function guardarPregunta() {
    var pregunta = document.getElementById('pregunta').value;
    var tipoRespuesta = document.getElementById('tipoRespuesta').value;
    var preguntasGuardadas = document.getElementById('preguntasGuardadas');

    if (pregunta) {
        var preguntaDiv = document.createElement('div');
        preguntaDiv.classList.add('pregunta');
        preguntaDiv.textContent = pregunta + ' (' + tipoRespuesta + ')';

        var botonEliminar = document.createElement('button');
        botonEliminar.textContent = 'Eliminar';
        botonEliminar.classList.add('boton-eliminar');
        botonEliminar.onclick = function() {
            preguntasGuardadas.removeChild(preguntaDiv);
        };

        preguntaDiv.appendChild(botonEliminar);
        preguntasGuardadas.appendChild(preguntaDiv);
        document.getElementById('pregunta').value = ''; // Limpiar el campo de la pregunta
    }
}

function guardarEncuesta() {
    var tituloEncuesta = document.getElementById('tituloEncuesta').value;
    var fechaInicio = document.getElementById('fechaInicio').value;
    var fechaFinal = document.getElementById('fechaFinal').value;
    var tipoPublico = document.getElementById('tipoPublico').value;
    var preguntas = [];
    var preguntasDivs = document.getElementsByClassName('pregunta');
    
    for (var i = 0; i < preguntasDivs.length; i++) {
        preguntas.push({
            pregunta: preguntasDivs[i].textContent.replace('Eliminar', '').trim(),
            tipo: preguntasDivs[i].textContent.match(/\(([^)]+)\)$/)[1]
        });
    }

    var encuesta = {
        titulo: tituloEncuesta,
        fechaInicio: fechaInicio,
        fechaFinal: fechaFinal,
        tipoPublico: tipoPublico,
        preguntas: preguntas
    };

    // Enviar la encuesta al servidor usando fetch
    fetch('guardar_encuesta.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(encuesta)
    }).then(response => response.json())
      .then(data => {
        if (data.success) {
            alert('Encuesta guardada exitosamente');
            document.getElementById('crearEncuesta').reset();
            document.getElementById('preguntasGuardadas').innerHTML = '';
        } else {
            alert('Error al guardar la encuesta');
        }
    });
}
