<?php
require 'conexion.php';

$data = json_decode(file_get_contents("php://input"), true);
$encuesta_id = $data['encuesta_id'];
$respuestas = $data['respuestas'];

try {
    $stmt = $conn->prepare("INSERT INTO respuestas (encuesta_id, pregunta_id, respuesta) VALUES (?, ?, ?)");
    foreach ($respuestas as $respuesta) {
        $stmt->execute([$encuesta_id, $respuesta['pregunta_id'], $respuesta['respuesta']]);
    }

    echo json_encode(["status" => "success", "message" => "Respuestas guardadas correctamente."]);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
