function cargarPreguntas() {
    fetch('obtener_preguntas.php')
    .then(response => response.json())
    .then(preguntas => {
        const container = document.getElementById('preguntasContainer');
        container.innerHTML = '';

        preguntas.forEach((pregunta, index) => {
            let inputElement;
            if (pregunta.tipo === 'texto') {
                inputElement = `<textarea name='respuesta${index}' required></textarea>`;
            } else if (pregunta.tipo === 'puntuacion') {
                inputElement = `<input type='number' min='${pregunta.rangoMin}' max='${pregunta.rangoMax}' name='respuesta${index}' required>`;
            } else if (pregunta.tipo === 'si_no') {
                inputElement = `<select name='respuesta${index}' required><option value='si'>Sí</option><option value='no'>No</option></select>`;
            }
            container.innerHTML += `<div class='form-group'><label>${pregunta.pregunta}</label>${inputElement}</div>`;
        });
    });
}

function enviarRespuestas() {
    const formData = new FormData(document.getElementById('formEncuesta'));

    fetch('guardar_respuestas.php', {
        method: 'POST',
        body: formData
    }).then(response => response.text())
    .then(data => alert(data));
}

window.onload = cargarPreguntas;