// Función para obtener los parámetros de la URL 
function getQueryParams() { 
    return{
        modulo:sessionStorage.getItem('modulo'), 
        empresa: sessionStorage.getItem('codemp') 
    }
    
}
async function obtenerDatos(modulo,empresa) {
    const respuestaVentas = await fetch('../pdo/pdoconsulta.php?modulo='+modulo+'&codemp='+empresa);
    const ventas = await respuestaVentas.json();
    return ventas;
}
const { modulo, empresa } = getQueryParams();
obtenerDatos(modulo,empresa).then(ventas => {
    console.log('Datos detallados de ventas:', ventas);
    const agrupadoDias = ventas.reduce((acc, item) => {
        if (!acc[item.dia]) {
            acc[item.dia] = { 
                dia: item.dia, 
                total_cantidad: 0, total_precio: 0, total_costo:0, total_utilidad:0 };
        }
        acc[item.dia].total_cantidad += parseInt(item.canart);
        acc[item.dia].total_precio += (item.vlrdcm*item.canart)-(item.vlrdto*item.canart);
        acc[item.dia].total_costo += (item.artcos*item.canart);
        acc[item.dia].total_utilidad += ((item.vlrdcm*item.canart)-(item.vlrdto*item.canart))-(item.artcos*item.canart);
        
        return acc;
    }, {});
    console.log(agrupadoDias)

    // Crear el gráfico de barras horizontal 
    const ctx = document.getElementById('myChart').getContext('2d'); 
    const myChart = new Chart(ctx, { 
        type: 'bar', 
        data: { 
            labels: Object.keys(agrupadoDias).map(key => agrupadoDias[key].dia), 
            datasets: [{ 
                label: 'Total Ganancia', 
                data: Object.keys(agrupadoDias).map(key => agrupadoDias[key].total_utilidad), 
                backgroundColor: 'rgba(75, 192, 192, 0.2)', 
                borderColor: 'rgba(75, 192, 192, 1)', borderWidth: 1 
            }] 
        }, 
        options: { 
            indexAxis: 'x', // Cambiar el eje a horizontal 
            scales: { 
                x: { 
                    beginAtZero: true
                 }
            } 
        } 
    });

    // Insertar datos en la tabla const 
    tableBody = document.getElementById('tablaVentas').getElementsByTagName('tbody')[0]; 
    tableBody.innerHTML = ''; // Limpiar la tabla antes de insertar nuevos datos
    let totalGeneralUtil = 0; 
    let totalGeneralCant = 0; 
    let totalGeneralCost = 0; 
    let totalGeneralVtas = 0; 
    Object.values(agrupadoDias).forEach(item => { 
        const row = tableBody.insertRow(); 
        const cell1 = row.insertCell(0); 
        const cell2 = row.insertCell(1); 
        const cell3 = row.insertCell(2); 
        const cell4 = row.insertCell(3); 
        const cell5 = row.insertCell(4); 
        cell1.textContent = item.dia; 
        cell2.textContent = item.total_cantidad;   
        cell3.textContent = new Intl.NumberFormat('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(item.total_precio);  
        cell4.textContent = new Intl.NumberFormat('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(item.total_costo); 
        cell5.textContent = new Intl.NumberFormat('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(item.total_utilidad);
        totalGeneralUtil += parseFloat(item.total_utilidad); 
        totalGeneralCant += parseFloat(item.total_cantidad); 
        totalGeneralCost += parseFloat(item.total_costo); 
        totalGeneralVtas += parseFloat(item.total_precio); 
       // totalGeneral += parseFloat(item.total_ganancia);
    });
    document.getElementById('divtotal').innerHTML='<p>Total Ventas: '+totalGeneralVtas+'</p>'+'<p>Total Costo: '+totalGeneralCost+'</p>'+
                '<p>Total Ganancias: '+totalGeneralUtil+'</p>'+'<p>Cant Prod Vendidos: '+totalGeneralCant+'</p>'

    // Agrupar por marcas
    const agrupadoMarcas = ventas.reduce((acc, item) => { 
        if (!acc[item.marca]) { 
            acc[item.marca] = { 
                marca: item.marca, 
                total_cantidad: 0, 
                total_precio: 0, 
                total_costo: 0, 
                total_utilidad: 0 
            }; 
        } 
        acc[item.marca].total_cantidad += parseInt(item.canart); 
        acc[item.marca].total_precio += (item.vlrdcm*item.canart)-(item.vlrdto*item.canart);
        acc[item.marca].total_costo += (item.artcos*item.canart);
        acc[item.marca].total_utilidad += ((item.vlrdcm*item.canart)-(item.vlrdto*item.canart))-(item.artcos*item.canart);

         
        return acc; 
    }, {}); 
    // Calcular el porcentaje de utilidad 
    Object.values(agrupadoMarcas).forEach(item => { 
        item.porcentaje_utilidad = (item.total_utilidad / item.total_precio) * 100; 
    });
    console.log(agrupadoMarcas)

    
     // Crear el gráfico de barras horizontal 
     const ctxmar = document.getElementById('myChartMar').getContext('2d'); 
     const myChartMar = new Chart(ctxmar, { 
         type: 'bar', 
         data: { 
             labels: Object.keys(agrupadoMarcas).map(key => agrupadoMarcas[key].marca), 
             datasets: [{ 
                 label: 'Ventas x Marcas', 
                 data: Object.keys(agrupadoMarcas).map(key => agrupadoMarcas[key].total_precio), 
                 backgroundColor: 'rgba(75, 192, 192, 0.2)', 
                 borderColor: 'rgba(75, 192, 192, 1)', borderWidth: 1 
             }] 
         }, 
         options: { 
             indexAxis: 'y', // Cambiar el eje a horizontal 
             scales: { 
                 x: { 
                     beginAtZero: true
                  }
             } 
         } 
     });

     // Insertar datos en la tabla const 
    //tableBody = document.getElementById('tablaMarcas').getElementsByTagName('tbody')[0]; 
    tableBody = document.getElementById('tmarca'); 
    tableBody.innerHTML = ''; // Limpiar la tabla antes de insertar nuevos datos
    Object.values(agrupadoMarcas).forEach(item => { 
        const row = tableBody.insertRow(); 
        const cell1 = row.insertCell(0); 
        const cell2 = row.insertCell(1); 
        const cell3 = row.insertCell(2); 
        const cell4 = row.insertCell(3); 
        const cell5 = row.insertCell(4); 
        cell1.textContent = item.marca; 
        cell2.textContent = item.total_cantidad;   
        cell3.textContent = new Intl.NumberFormat('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(item.total_precio);  
        cell4.textContent = new Intl.NumberFormat('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(item.total_costo); 
        cell5.textContent = new Intl.NumberFormat('es-ES', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(item.total_utilidad);
    });

    // Agrupar por vendedores
    const agrupadoVendedores = ventas.reduce((acc, item) => {
        if (!acc[item.nriven]) {
            acc[item.nriven] = { vendedor: item.nriven, total_cantidad: 0, total_precio: 0 };
        }
        acc[item.nriven].total_cantidad += item.canart; 
        acc[item.nriven].total_precio += (item.vlrdcm*item.canart)-(item.vlrdto*item.canart);
        acc[item.nriven].total_costo += (item.artcos*item.canart);
        acc[item.nriven].total_utilidad += ((item.vlrdcm*item.canart)-(item.vlrdto*item.canart))-(item.artcos*item.canart);

        return acc;
    }, {});
    console.log(agrupadoVendedores)
     // Crear el gráfico de barras horizontal 
     const ctxvend = document.getElementById('myChartVen').getContext('2d'); 
     const myChartVen = new Chart(ctxvend, { 
         type: 'bar', 
         data: { 
             labels: Object.keys(agrupadoVendedores).map(key => agrupadoVendedores[key].vendedor), 
             datasets: [{ 
                 label: 'Ventas x vendedores', 
                 data: Object.keys(agrupadoVendedores).map(key => agrupadoVendedores[key].total_precio), 
                 backgroundColor: 'rgba(75, 192, 192, 0.2)', 
                 borderColor: 'rgba(75, 192, 192, 1)', borderWidth: 1 
             }] 
         }, 
         options: { 
             indexAxis: 'y', // Cambiar el eje a horizontal 
             scales: { 
                 x: { 
                     beginAtZero: true
                  }
             } 
         } 
     });


    // Agrupar por líneas de productos
    const agrupadoLineas = ventas.reduce((acc, item) => {
        if (!acc[item.linea]) {
            acc[item.linea] = { linea: item.linea, total_cantidad: 0, total_precio: 0 };
        }
        acc[item.linea].total_cantidad += item.canart;
        acc[item.linea].total_precio += item.vlrdcm*item.canart;
        return acc;
    }, {});

    console.log(agrupadoLineas)
    const lineas = Object.keys(agrupadoLineas);
    const totalPrecios = lineas.map(linea => agrupadoLineas[linea].total_precio);
    const totalGeneral = totalPrecios.reduce((acc, precio) => acc + precio, 0);
    const porcentajes = totalPrecios.map(precio => (precio / totalGeneral) * 100);
    

const ctxLin = document.getElementById('myChartLin').getContext('2d');
const myChartLin = new Chart(ctxLin, {
    type: 'doughnut',
    data: {
        labels: lineas,
        datasets: [{
            label: 'Total Precio',
            data: totalPrecios,
            backgroundColor: lineas.map(() => getRandomColor()),
            borderColor: lineas.map(() => '#fff'),
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
          plugins: {
            legend: {
                position: 'right',
                labels: {
                    boxWidth: 20,
                    padding: 20,
                    generateLabels: function(chart) {
                        const data = chart.data;
                        return data.labels.map((label, i) => {
                            const value = data.datasets[0].data[i];
                            const percentage = porcentajes[i].toFixed(2) + '%';
                            return {
                                text: `${label}: ${percentage}`,
                                fillStyle: data.datasets[0].backgroundColor[i],
                                hidden: false,
                                index: i
                            };
                        });
                    }
                }
            },
            tooltip: {
                position: 'nearest', // Posición del tooltip
                callbacks: {
                    label: function(context) {
                        let label = context.label || '';
                        if (label) {
                            label += ': ';
                        }
                        if (context.raw !== null) {
                            label += new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(context.raw);
                        }
                        return label;
                    }
                }
            },
            title: { 
                display: true, text: 'Distribución de Precios por Línea de Producto' 
            }
        },
        cutout: '50%' // Hacer el anillo más pequeño
    }
});




const ctxp = document.getElementById('myChartvProd').getContext('2d');

// Datos agrupados obtenidos de PHP
const agrupadoItems = ventas.reduce((acc, item) => {
    if (!acc[item.artcod]) {
        acc[item.artcod] = { producto: item.artcod, total_cantidad: 0, total_precio: 0, total_costo: 0, total_utilidad: 0 };
    }
    acc[item.artcod].total_cantidad += parseInt(item.canart); 
    acc[item.artcod].total_precio += (item.vlrdcm * item.canart) - (item.vlrdto * item.canart);
    acc[item.artcod].total_costo += (item.artcos * item.canart);
    acc[item.artcod].total_utilidad += ((item.vlrdcm * item.canart) - (item.vlrdto * item.canart)) - (item.artcos * item.canart);
    
    return acc;
}, {});

// Convertir los datos agrupados en un formato que Chart.js pueda usar
const labels = Object.keys(agrupadoItems);
const totalCantidad = labels.map(label => agrupadoItems[label].total_cantidad);
const totalPrecio = labels.map(label => agrupadoItems[label].total_precio);
const totalCosto = labels.map(label => agrupadoItems[label].total_costo);
const totalUtilidad = labels.map(label => agrupadoItems[label].total_utilidad);

const salesData = {
    labels: labels,
    datasets: [
        {
            label: 'Total Cantidad',
            data: totalCantidad,
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            borderColor: 'rgba(75, 192, 192, 1)',
            borderWidth: 1,
            fill: true
        },
        {
            label: 'Total Precio',
            data: totalPrecio,
            backgroundColor: 'rgba(153, 102, 255, 0.2)',
            borderColor: 'rgba(153, 102, 255, 1)',
            borderWidth: 1,
            fill: true
        },
        {
            label: 'Total Costo',
            data: totalCosto,
            backgroundColor: 'rgba(255, 159, 64, 0.2)',
            borderColor: 'rgba(255, 159, 64, 1)',
            borderWidth: 1,
            fill: true
        },
        {
            label: 'Total Utilidad',
            data: totalUtilidad,
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderColor: 'rgba(255, 99, 132, 1)',
            borderWidth: 1,
            fill: true
        }
    ]
};

// Configuración del gráfico
const config = {
    type: 'line', // Usamos 'line' para el gráfico de área
    data: salesData,
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
};

// Crear y renderizar el gráfico
const salesChart = new Chart(ctxp, config);


    function getRandomColor() {
        const letters = '0123456789ABCDEF';
        let color = '#';
        for (let i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }
    

    return;
    // Insertar datos detallados de ventas en la tabla
    const tableBodyVentas = document.getElementById('tablaVentas').getElementsByTagName('tbody')[0];
    ventas.forEach(item => {
        const row = tableBodyVentas.insertRow();
        const cell1 = row.insertCell(0);
        const cell2 = row.insertCell(1);
        const cell3 = row.insertCell(2);
        cell1.textContent = item.producto;
        cell2.textContent = item.cantidad;
        cell3.textContent = item.precio;
    });

    // Insertar datos agrupados por marcas en la tabla
    const tableBodyMarcas = document.getElementById('tablaMarcas').getElementsByTagName('tbody')[0];
    Object.values(agrupadoMarcas).forEach(item => {
        const row = tableBodyMarcas.insertRow();
        const cell1 = row.insertCell(0);
        const cell2 = row.insertCell(1);
        const cell3 = row.insertCell(2);
        cell1.textContent = item.marca;
        cell2.textContent = item.total_cantidad;
        cell3.textContent = item.total_precio;
    });

    // Insertar datos agrupados por vendedores en la tabla
    const tableBodyVendedores = document.getElementById('tablaVendedores').getElementsByTagName('tbody')[0];
    Object.values(agrupadoVendedores).forEach(item => {
        const row = tableBodyVendedores.insertRow();
        const cell1 = row.insertCell(0);
        const cell2 = row.insertCell(1);
        const cell3 = row.insertCell(2);
        cell1.textContent = item.vendedor;
        cell2.textContent = item.total_cantidad;
        cell3.textContent = item.total_precio;
    });

    // Insertar datos agrupados por líneas de productos en la tabla
    const tableBodyLineas = document.getElementById('tablaLineas').getElementsByTagName('tbody')[0];
    Object.values(agrupadoLineas).forEach(item => {
        const row = tableBodyLineas.insertRow();
        const cell1 = row.insertCell(0);
        const cell2 = row.insertCell(1);
        const cell3 = row.insertCell(2);
        cell1.textContent = item.linea;
        cell2.textContent = item.total_cantidad;
        cell3.textContent = item.total_precio;
    });

    // Aquí puedes agregar código para crear gráficos con Chart.js o cualquier otra librería
});
