document.addEventListener('DOMContentLoaded', function() { 
    if(VGmodulo=='marcas' || VGmodulo=='liteproducts' || VGmodulo=='categoria'){

    
        const dropzone = document.getElementById('dropzone'); 
        const fileInput = document.getElementById('images'); 
        const preview = document.getElementById('preview'); 
        const errorDiv = document.getElementById('error');
        const maxFileSize = 5000000; // 5MB
        const allowedFileTypes = ['image/jpeg', 'image/png', 'image/gif'];

        dropzone.addEventListener('dragover', function(event) { 
            event.preventDefault(); 
            dropzone.classList.add('dragover'); 
        }); 
        dropzone.addEventListener('dragleave', function() { 
            dropzone.classList.remove('dragover'); 
        }); 
        dropzone.addEventListener('drop', function(event) { 
            event.preventDefault(); 
            dropzone.classList.remove('dragover'); 
            const files = event.dataTransfer.files; 
            fileInput.files = files; 
            handleFiles(files); 
        }); 
        fileInput.addEventListener('change', function(event) { 
            const files = event.target.files; 
            handleFiles(files); 
        }); 
        function handleFiles(files) { 
            preview.innerHTML = ''; 
            errorDiv.innerHTML = '';
            let valid = true;
            for (let i = 0; i < files.length; i++) {
                const file = files[i]; 
                if (!allowedFileTypes.includes(file.type)) {
                    errorDiv.innerHTML += `<p>El archivo ${file.name} no es un tipo de imagen permitido.</p>`;
                    valid = false;
                }

                if (file.size > maxFileSize) {
                    errorDiv.innerHTML += `<p>El archivo ${file.name} excede el tamaño máximo permitido de 5MB.</p>`;
                    valid = false;
                }
                if (valid) {
                    const reader = new FileReader(); 
                    reader.onload = function(e) {
                        const img = document.createElement('img'); 
                        img.src = e.target.result; 
                        preview.appendChild(img); 
                    }; 
                    reader.readAsDataURL(file); 
                }
            } 
            if (!valid) {
                fileInput.value = ''; // Reset file input if validation fails
            } 
        }   
    
        //document.getElementById('imageForm').addEventListener('submit', function(event) {
        //    if (fileInput.files.length === 0) {
        //        errorDiv.innerHTML = '<p>No se han seleccionado archivos válidos para subir.</p>';
        //        event.preventDefault();
        //    }
        //});
    }
});