// Función para generar un ID único
function generarId() {
    return '_' + Math.random().toString(36).substr(2, 9);
  }
  
  /*function agregarItem(tabla, arg1, arg2, arg3) {
    const categoria = document.getElementById('artcla');
    const producto = document.getElementById('idproducto');
    const cantidad = document.getElementById('cantidad').value;
    const precio = document.getElementById('precio').value;
  
    const item = {
      categoria: categoria.options[categoria.selectedIndex].text,
      producto: producto.options[producto.selectedIndex].text,
      cantidad,
      precio
    };
  
    let items = JSON.parse(localStorage.getItem('items')) || [];
    items.push(item);
    localStorage.setItem('items', JSON.stringify(items));
    renderItems();
  }*/
    function agregarItem(tabla, arg1, arg2, arg3, prod = null) {
    const elementos = document.querySelectorAll('.Items');

    // === CÁLCULO DE BASE SI EXISTE ===
    const baseInput = document.querySelector('.base');
    if (baseInput) {
        const precioInput = document.querySelector('.precio');
        const porivaInput = document.querySelector('.poriva');
        const chkivaInput = document.querySelector('.chkiva');

        const precio = parseCantidad(precioInput?.value);
        const poriva = parseCantidad(porivaInput?.value);
        const chkiva = parseInt(chkivaInput?.value.replace(/,/g, '')) || 0;

        let base = precio;
        if (chkiva === 1 && poriva > 0) {
            base = precio / (1 + poriva / 100);
        }

        baseInput.value = base.toFixed(2);
    }

    let item = {};

    if (prod) {
        item = { ...prod };
    } else {
        elementos.forEach(el => {
            console.log(`ID: ${el.id}, Valor: ${el.value}`);
        });

        elementos.forEach(elemento => {
            if (elemento.tagName === 'SELECT') {
                item[elemento.id] = elemento.options[elemento.selectedIndex].text;
            } else {
                item[elemento.id] = elemento.value;
            }
        });
    }

    let items = JSON.parse(localStorage.getItem('items')) || [];

    // ✅ Verificar si ya existe un item con el mismo Id
    let indexExistente = -1;
    if (vGmodulo != 'fventasjhoyos') {
        indexExistente = items.findIndex(i => i.Id == item.Id);
    }

    if (indexExistente >= 0) {
        // Ya existe => incrementar cantidad
        if ('cantidad' in items[indexExistente]) {
            items[indexExistente].cantidad = parseCantidad(items[indexExistente].cantidad) + 1;
        } else if ('canart' in items[indexExistente]) {
            items[indexExistente].canart = parseCantidad(items[indexExistente].canart) + 1;
        } else {
            items[indexExistente].cantidad = 1;
        }
        console.log(`Item con Id ${item.Id} ya existe, incrementada cantidad`);
    } else {
        // Nuevo item, inicializar cantidad o canart
        if (!('cantidad' in item) && !('canart' in item)) {
            item.cantidad = 1;
        } else if ('cantidad' in item) {
            item.cantidad = parseCantidad(item.cantidad);
        } else if ('canart' in item) {
            item.canart = parseCantidad(item.canart);
        }

        if (!item.hasOwnProperty('observacion')) {
            item.observacion = '';
        }

        items.push(item);
        console.log(`Nuevo item agregado con Id ${item.Id}`);
    }

    localStorage.setItem('items', JSON.stringify(items));
    console.log("Todos los items en localStorage:", items);
    renderItems();
}

// ✅ Función auxiliar para limpiar y convertir cantidades
function parseCantidad(valor) {
    if (typeof valor === 'string') {
        // Quita todo excepto números, punto y signo negativo
        valor = valor.replace(/,/g, '').replace(/[^\d.-]/g, '').trim();
    }
    const num = parseFloat(valor);
    return isNaN(num) ? 1 : num;
}

  
  function formatWithSeparators(numero) {
    const decimales = (typeof vGempresa !== 'undefined' && vGempresa === 'mamioli') ? 0 : 2;
    return parseCantidad(numero).toLocaleString('en-US', {
        minimumFractionDigits: decimales,
        maximumFractionDigits: decimales
    });
}
  
  
  
  function eliminarItem(index) {
    let items = JSON.parse(localStorage.getItem('items')) || [];
    items.splice(index, 1);
    localStorage.setItem('items', JSON.stringify(items));
    renderItems();
  }
  

  function editarItem(index, campo, valor) {
    let items = JSON.parse(localStorage.getItem('items')) || [];
  
    if (!items[index]) return;
  
    items[index][campo] = valor;
  
    const afectado = ['precio', 'poriva', 'chkiva'];
    if (afectado.includes(campo)) {
      const precio = parseFloat((items[index]['precio'] || '0').toString().replace(/,/g, '')) || 0;
      const poriva = parseFloat((items[index]['poriva'] || '0').toString().replace(/,/g, '')) || 0;
      const chkiva = parseInt((items[index]['chkiva'] || '0').toString().replace(/,/g, '')) || 0;
  
      let base = precio;
      if (chkiva === 1 && poriva > 0) {
        base = precio / (1 + poriva / 100);
      }
  
      items[index]['vlrdcm'] = base.toFixed(2);
    }
  
    localStorage.setItem('items', JSON.stringify(items));
  
    // ✅ Renderizar SIEMPRE después de editar
    renderItems();
  }
  
  function renderItems() {
    const contenedor = document.getElementById('det_prod');
    contenedor.innerHTML = '';

    let items = JSON.parse(localStorage.getItem('items')) || [];

    if (items.length === 0) {
        contenedor.innerHTML = '<p>No hay elementos registrados.</p>';
        return;
    }

    const headers = Object.keys(items[0]);
    if (!headers.includes('observacion')) {
        headers.push('observacion');
    }

    let total = 0;

    const principales = items.filter(item => !item.IdPadre);

    principales.forEach((item, i) => {
        let itemHtml = '<div class="item-listado">';

        headers.forEach(key => {
            if (key !== 'observacion') {
                let valor = item[key];
                if (key === 'cantidad' || key === 'canart' || key === 'precio') {
                    valor = formatWithSeparators(valor);
                    itemHtml += `
                        <div class="item-celda">
                            <input type="text" value="${valor}" 
                                oninput="formatNumber(this)" 
                                onchange="editarItem(${i}, '${key}', this.value)">
                        </div>`;
                } else {
                    itemHtml += `<div class="item-celda">${valor}</div>`;
                }
            }
        });

        if (VGproyect != "rest") {
            itemHtml += `
                <div class="item-celda">
                    <button class="btn-eliminar" onclick="eliminarItem(${i})">🗑️</button>
                </div>`;
        } else {
            itemHtml += `
                <div class="item-celda">
                    <button class="btn-eliminar" onclick="eliminarItem(${i})">🗑️</button>
                    <button class="btn-adicional" onclick="agregarAdicionalPrompt(${item.Id})">➕ Adicional</button>
                </div>`;
        }

        if (vGmodulo !== "fventasjhoyos" && vGmodulo !== "fcompraslite") {
            // Observación
            itemHtml += `
                <div class="item-observacion" id="obs-${i}" style="display: none; height: 40px; width: 80%; margin: 0.5em auto; border: 1px dashed #ccc; padding: 2px; align-items: center;">
                    <span id="obs-txt-${i}" style="display: inline-block; width: 100%;">${item.observacion || ''}</span>
                    <textarea 
                        id="obs-input-${i}" 
                        style="display: none; width: 100%; height: 100%; box-sizing: border-box;" 
                        onblur="guardarObservacion(${i}, this.value)">
                        ${item.observacion || ''}
                    </textarea>
                </div>
                <div class="observacion-control" style="text-align: right;">
                    <button onclick="mostrarEditorObservacion(${i})">✏️ </button>
                </div>`;

            const dependientes = items.filter(dep => dep.IdPadre === item.Id);
            if (dependientes.length > 0) {
                dependientes.forEach(dep => {
                    const sub = parseCantidad(dep.precio) * parseCantidad(dep.cantidad || dep.canart);
                    const subtotalDep = formatWithSeparators(sub);
                    itemHtml += `
                    <div class="adicional-item" style="margin: 0.5em 0; padding: 0.5em; border: 1px dashed #aaa; background: #f9f9f9; display: flex; gap: 0.5em; align-items: center;">
                        <span style="flex: 1;">${dep.nombre}</span>
                        <input type="number" min="1" value="${parseCantidad(dep.cantidad || dep.canart)}" style="width: 50px;"
                            onchange="editarItemPorId(${dep.Id}, 'cantidad', this.value)">
                        x $${formatWithSeparators(dep.precio)}
                        <span>= $${subtotalDep}</span>
                        <button onclick="eliminarItemPorId(${dep.Id})">❌</button>
                    </div>`;
                    total += sub;
                });
            }
        }

        contenedor.innerHTML += itemHtml;

        const precio = parseCantidad(item.precio);
        const cantidad = parseCantidad(item.cantidad !== undefined ? item.cantidad : item.canart);
        total += precio * cantidad;
    });

    localStorage.setItem('totalFactura', total.toString());

    // Mostrar total
    const totalHtml = `
        <div class="item-total" style="text-align: right; font-weight: bold; margin-top: 1em;">
            Total: $${formatWithSeparators(total)}
        </div>`;
    contenedor.innerHTML += totalHtml;
    document.getElementById("det_pago").innerHTML="";
    localStorage.setItem('pagos', JSON.stringify(pagos));
}





function mostrarEditorObservacion(index) {
  const obsDiv = document.getElementById(`obs-${index}`);
  const span = document.getElementById(`obs-txt-${index}`);
  const input = document.getElementById(`obs-input-${index}`);

  obsDiv.style.display = 'flex';
  span.style.display = 'none'; // ocultamos el texto
  input.style.display = 'inline-block'; // mostramos el textarea
  input.focus(); // opcional: enfocar automáticamente
}



function guardarObservacion(index, valor) {
  let items = JSON.parse(localStorage.getItem('items')) || [];
  if (!items[index]) return;

  items[index].observacion = valor;
  localStorage.setItem('items', JSON.stringify(items));

  // Actualizar UI
  const obsDiv = document.getElementById(`obs-${index}`);
  const span = document.getElementById(`obs-txt-${index}`);
  const input = document.getElementById(`obs-input-${index}`);

  span.textContent = valor;
  input.style.display = 'none'; // ocultar textarea
  span.style.display = 'inline-block'; // mostrar texto
  //renderItems();
}

function ajustarCantidad(index, delta) {
  let items = JSON.parse(localStorage.getItem('items')) || [];
  let cantidad = parseInt(items[index].cantidad) || 1;
  cantidad += delta;
  if (cantidad < 1) cantidad = 1;
  items[index].cantidad = cantidad;
  localStorage.setItem('items', JSON.stringify(items));
  renderItems();
}

function agregarAdicionalPrompt(idPadre) {
  filtrar("adicionalesrest","","","","img","","t","na");
  //aqui debemos almacenar el Id padre para que cuando se adicione el adicional ponga el Id al que pertenece
  return
  const nombre = prompt("Nombre del adicional:");
  if (!nombre) return;
  const precio = parseFloat(prompt("Precio del adicional:")) || 0;
  const cantidad = parseInt(prompt("Cantidad:")) || 1;

  let items = JSON.parse(localStorage.getItem('items')) || [];

  const nuevoAdicional = {
      Id: Date.now(), // único
      nombre,
      precio,
      cantidad,
      IdPadre: idPadre
  };

  items.push(nuevoAdicional);
  localStorage.setItem('items', JSON.stringify(items));
  renderItems();
}

function editarItemPorId(id, campo, valor) {
  let items = JSON.parse(localStorage.getItem('items')) || [];
  const index = items.findIndex(item => item.Id == id);
  if (index >= 0) {
      items[index][campo] = valor;
      localStorage.setItem('items', JSON.stringify(items));
      renderItems();
  }
}

function eliminarItemPorId(id) {
  let items = JSON.parse(localStorage.getItem('items')) || [];
  items = items.filter(item => item.Id != id);
  localStorage.setItem('items', JSON.stringify(items));
  renderItems();
}


  
  function agregarAlCarrito(producto) {
    // Obtener el carrito actual
    let carrito = JSON.parse(localStorage.getItem('carrito')) || [];

    // Buscar si el producto ya está en el carrito
    const index = carrito.findIndex(item => item.id === producto.id);

    if (index !== -1) {
        // Si ya existe, aumentar cantidad
        carrito[index].cantidad += 1;
    } else {
        // Si no existe, agregar nuevo con cantidad = 1
        producto.cantidad = 1;
        carrito.push(producto);
    }

    // Guardar actualizado
    localStorage.setItem('carrito', JSON.stringify(carrito));

    // Opcional: mostrar mensaje o actualizar la UI
    console.log('Producto agregado al carrito:', producto);

    // Actualizar formulario (si aplica en ese momento)
    renderItems();
    //cargarItemsEnFormulario();
}

function cargarItemsEnFormulario() {
    const carrito = JSON.parse(localStorage.getItem('carrito')) || [];
    const tablaItems = document.getElementById('tabla-items'); // ID de tu tabla de ítems

    tablaItems.innerHTML = ''; // Limpiar antes de recargar

    carrito.forEach(item => {
        const fila = document.createElement('tr');

        const tdNombre = document.createElement('td');
        tdNombre.textContent = item.nombre;

        const tdCantidad = document.createElement('td');
        tdCantidad.textContent = item.cantidad;

        const tdPrecio = document.createElement('td');
        tdPrecio.textContent = `$${item.precio.toLocaleString()}`;

        const tdTotal = document.createElement('td');
        tdTotal.textContent = `$${(item.precio * item.cantidad).toLocaleString()}`;

        fila.appendChild(tdNombre);
        fila.appendChild(tdCantidad);
        fila.appendChild(tdPrecio);
        fila.appendChild(tdTotal);

        tablaItems.appendChild(fila);
    });
}
  