function agregarPagos() {
    //Excluye Labels
    const elementos = Array.from(document.querySelectorAll('.Pagos'))
    .filter(el => el.tagName.toLowerCase() !== 'label');

    let nuevoPago = {};

    elementos.forEach(el => {
        const nombreCampo = el.name || el.getAttribute('data-name') || '';
        let valorCampo = el.value;

        console.log('Campo:', nombreCampo, 'Valor:', valorCampo);

        if (nombreCampo === 'vlrpgo') {
            // ✅ limpiar separadores de miles
            valorCampo = parseFloat(valorCampo.toString().replace(/,/g, '')) || 0;
        }

        if (nombreCampo) {
            nuevoPago[nombreCampo] = valorCampo;
        }
    });

    // Asignar ID único
    nuevoPago['Id'] = Date.now();

    // Obtener pagos existentes
    let pagos = JSON.parse(localStorage.getItem('pagos')) || [];
    pagos.push(nuevoPago);

    // Guardar en localStorage
    localStorage.setItem('pagos', JSON.stringify(pagos));

    // ✅ Calcular total pagado
    const totalPagado = pagos.reduce((acc, pago) => acc + (parseFloat(pago.vlrpgo) || 0), 0);

    // ✅ Obtener total de la factura
    const totalFactura = parseFloat(localStorage.getItem('totalFactura')) || 0;
    console.log(totalPagado)
    // ✅ Calcular saldo pendiente
    const saldoPendiente = totalFactura - totalPagado;
    localStorage.setItem('totalSaldo', saldoPendiente);

    // ✅ Actualizar el input vlrrecibido con el saldo pendiente
    const recibidoEl = document.getElementById('vlrrecibido');
    if (recibidoEl) {
        recibidoEl.value = saldoPendiente > 0 ? saldoPendiente.toLocaleString('en-US') : '0';
    }

    // ✅ Mostrar u ocultar las casillas .Pagos según saldo
    const elementosPagos = document.querySelectorAll('.Pagos');
    if (saldoPendiente <= 0) {
        elementosPagos.forEach(el => el.style.display = 'none');
    } else {
        elementosPagos.forEach(el => el.style.display = '');
    }

    // ✅ Renderizar pagos actualizados
    renderPagos();
}


function editarPago(index, nuevoValor) {
    let pagos = JSON.parse(localStorage.getItem('pagos')) || [];
    pagos[index].vlrpgo = parseFloat(nuevoValor) || 0;
    localStorage.setItem('pagos', JSON.stringify(pagos));
    renderPagos();
}

function eliminarPago(index) {
    let pagos = JSON.parse(localStorage.getItem('pagos')) || [];
    pagos.splice(index, 1);
    localStorage.setItem('pagos', JSON.stringify(pagos));
    renderPagos();
}

function renderPagos() {
    const contenedor = document.getElementById('det_pagos');
    contenedor.innerHTML = '';

    let pagos = JSON.parse(localStorage.getItem('pagos')) || [];

    if (pagos.length === 0) {
        contenedor.innerHTML = '<p>No hay pagos registrados.</p>';
        return;
    }

    let totalPagos = 0;

    pagos.forEach((pago, index) => {
        let pagoHtml = `<div class="pago-item" style="display: flex; align-items: center; gap: 1em; border-bottom: 1px solid #ddd; padding: 0.5em 0;">`;

        // Mostrar dinámicamente las propiedades excepto 'Id' y 'vlrpgo'
        for (let key in pago) {
            if (key === 'Id' || key === 'vlrpgo') continue; // ignorar estos en el texto
            pagoHtml += `<div style="flex: 1;">${pago[key]}</div>`;
        }

        // ✅ formatear vlrpgo con separador de miles COMA y decimal PUNTO
        let valorNumerico = parseFloat(pago.vlrpgo) || 0;
        //let valorFormateado = valorNumerico.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        let valorFormateado = valorNumerico.toLocaleString('en-US');


        pagoHtml += `
            <input type="text" value="${valorFormateado}"  
                style="width: 100px; text-align: right;" 
                oninput="formatNumber(this)"
                onchange="editarPago(${index}, this.value)">
            <button onclick="eliminarPago(${index})">🗑️</button>
        </div>`;

        contenedor.innerHTML += pagoHtml;

        totalPagos += valorNumerico;
    });

    contenedor.innerHTML += `
    <div style="text-align: right; font-weight: bold; margin-top: 1em;">
        Total Pagado: $${Math.round(totalPagos).toLocaleString('en-US')}
    </div>`;

    const totalFactura = parseFloat(localStorage.getItem("totalFactura"));
    
    const saldo = totalFactura - totalPagos;

    contenedor.innerHTML += `
        <div style="text-align: right; font-weight: bold; margin-top: 1em;">
            Total Pagado: $${totalPagos.toLocaleString('en-US')}
        </div>
        <div style="text-align: right; font-weight: bold; margin-top: 0.5em;">
            Saldo a Pagar: $${saldo.toLocaleString('en-US')}
        </div>
    `;
    localStorage.setItem('totalSaldo', saldo.toString());

}
function cambio(origenInput) {
    const recibidoEl = document.getElementById("vlrrecibido");
    const pagoEl = document.getElementById("vlrpgo");
    const vueltasEl = document.getElementById("vueltas");

    let saldoPendiente = parseFloat(localStorage.getItem("totalSaldo"));
    const totalFactura = parseFloat(localStorage.getItem("totalFactura"));

    // ✅ si no hay saldoPendiente, usar totalFactura
    if (isNaN(saldoPendiente) || saldoPendiente <= 0) {
        saldoPendiente = totalFactura || 0;
    }

    const valorRecibido = parseFloat(recibidoEl.value.replace(/,/g, '')) || 0;
    const valorPagoActual = parseFloat(pagoEl.value.replace(/,/g, '')) || 0;

    const idOrigen = origenInput.id;

    if (idOrigen === "vlrrecibido") {
        if (valorRecibido <= saldoPendiente) {
            // ✅ asigna directamente sin formato
            pagoEl.value = recibidoEl.value;
        } else {
            console.warn(`⚠️ Valor recibido supera saldo pendiente.`);
            pagoEl.value = saldoPendiente.toLocaleString('en-US');
        }
    }

    const valorPagoFinal = parseFloat(pagoEl.value.replace(/,/g, '')) || 0;
    const vueltas = valorRecibido - valorPagoFinal;

    vueltasEl.value = vueltas >= 0 ? vueltas.toLocaleString('en-US') : '0';
}


function actualizarVisibilidadPagos() {
    const saldoPendiente = parseFloat(localStorage.getItem('totalSaldo')) || 0;
    const elementosPagos = document.querySelectorAll('.Pagos');

    if (saldoPendiente <= 0) {
        elementosPagos.forEach(el => el.style.display = 'none');
    } else {
        elementosPagos.forEach(el => el.style.display = '');
    }
}


