function actualizarFiltro() {
    let tipo = document.getElementById('tipoFiltro').value;
    document.getElementById('filtroDiario').style.display = tipo === 'diario' ? 'inline-block' : 'none';
    document.getElementById('filtroSemanal').style.display = tipo === 'semanal' ? 'inline-block' : 'none';
    document.getElementById('filtroMensual').style.display = tipo === 'mensual' ? 'inline-block' : 'none';
    document.getElementById('filtroInicio').style.display = tipo === 'rango' ? 'inline-block' : 'none';
    document.getElementById('filtroFin').style.display = tipo === 'rango' ? 'inline-block' : 'none';
}

function obtenerFechaSeleccionada() {
    let tipo = document.getElementById('tipoFiltro').value;
    if (tipo === 'diario') return document.getElementById('filtroDiario').value;
    if (tipo === 'semanal') return document.getElementById('filtroSemanal').value;
    if (tipo === 'mensual') return document.getElementById('filtroMensual').value;
    if (tipo === 'rango') return {
        inicio: document.getElementById('filtroInicio').value,
        fin: document.getElementById('filtroFin').value
    };
}

function mostrarTab(tab) {
    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
    document.querySelector(`[onclick="mostrarTab('${tab}')"]`).classList.add('active');
    document.getElementById(tab).classList.add('active');
}

function cargarDatos(tipo) {
    console.log(tipo);
    let tabla = document.getElementById(tipo === 'ingresos' ? 'tablaIngresos' : 'tablaGastos');
    let tbody = tabla.querySelector('tbody');
    let thead = tabla.querySelector('thead');
    tbody.innerHTML = '';
    thead.innerHTML = '';

    let empresa = 'mamioli';
    let tipoFiltro = document.getElementById('tipoFiltro').value;
    let filtro = obtenerFechaSeleccionada();

    let url = `pdo/pdopanel.php?tipo=${tipo}&codemp=${empresa}&tipoFiltro=${tipoFiltro}&filtro=${encodeURIComponent(JSON.stringify(filtro))}`;
    
    fetch(url)
        .then(response => response.text())  // Obtener la respuesta en texto plano
        .then(textoPlano => {
            console.log("Respuesta en texto plano:", textoPlano); // Mostrar el texto en la consola
            return JSON.parse(textoPlano); // Luego convertirlo a JSON
        })
        .then(datos => {
        console.log("Datos convertidos a JSON:", datos); // Mostrar el JSON convertido
        if (datos.length === 0) {
            tbody.innerHTML = '<tr><td colspan="100%">No hay datos disponibles</td></tr>';
            return;
        }
            let headers = Object.keys(datos[0]);
            let trHead = document.createElement('tr');
            headers.forEach(header => {
                let th = document.createElement('th');
                th.textContent = header.replace(/_/g, ' ').toUpperCase();
                trHead.appendChild(th);
            });
            
            thead.appendChild(trHead);

            // Crear cuerpo de la tabla y calcular el total de la columna "total"
            let fragment = document.createDocumentFragment();
            let total = 0; // Variable para el total de la columna "total"
            let totalesColumnas = {}; // Objeto para acumular totales por columna

            /*datos.forEach(d => {
                let tr = document.createElement('tr');
                headers.forEach(header => {
                    let td = document.createElement('td');
                    //td.textContent = d[header] || ''; 
                    td.textContent = d[header] ?? '';
                    tr.appendChild(td);
                    
                    // Sumar valores de la columna "total" si existe y es numérico
                    if (header === 'total' && typeof d[header] === 'number') {
                        total += d[header];
                    }

                });
                fragment.appendChild(tr);
                //tbody.appendChild(tr);
            });*/
            datos.forEach(d => {
                let tr = document.createElement('tr');
                headers.forEach(header => {
                    let td = document.createElement('td');
                    td.textContent = d[header] ?? '';
                    tr.appendChild(td);
            
                    // Verifica si el valor es numérico y acumula por columna
                    let valor = parseFloat(d[header]);
                    if (!isNaN(valor)) {
                        totalesColumnas[header] = (totalesColumnas[header] || 0) + valor;
                    }

                   

                });
                fragment.appendChild(tr);
            });
            console.log(total);
            
            tbody.appendChild(fragment);

            let totalGeneral = totalesColumnas['total'] ?? 0;
console.log("Total general:", totalGeneral);
            document.getElementById('totingresos').textContent = totalGeneral.toFixed(2);
            // Crear fila de totales
let trTotales = document.createElement('tr');
headers.forEach(header => {
    let td = document.createElement('td');
    if (totalesColumnas.hasOwnProperty(header)) {
        td.textContent = totalesColumnas[header].toFixed(2); // Redondeo a 2 decimales
        td.style.fontWeight = 'bold';
        td.style.backgroundColor = '#f0f0f0';
    } else {
        td.textContent = ''; // Celdas vacías para columnas no numéricas
    }
    trTotales.appendChild(td);
});
tbody.appendChild(trTotales);


            // Mostrar el total en la consola (opcional: agregarlo en la tabla o interfaz)
            console.log(`Total de la columna 'total':`, total);
            if(tipo=="ingresos"){
                //document.getElementById("totingresos").innerHTML=total
            }else{
                document.getElementById("totgastos").innerHTML=total
            }

            // Opcional: añadir una fila al final con el total
            //let trTotal = document.createElement('tr');
            //trTotal.innerHTML = `<td colspan="${headers.length - 1}" style="text-align: right; font-weight: bold;">TOTAL:</td>
            //<td style="font-weight: bold;">${total}</td>`;
            //tbody.appendChild(trTotal);

        })
        .catch(error => console.error('Error cargando los datos:', error));
}

actualizarFiltro();
document.getElementById('filtroMes').addEventListener('change', function() {
    cargarDatos('ingresos');
    cargarDatos('gastos');
});

function exportarExcel(tablaId) {
    let tabla = document.getElementById(tablaId);
    let wb = XLSX.utils.book_new();
    let ws = XLSX.utils.table_to_sheet(tabla);
    XLSX.utils.book_append_sheet(wb, ws, tablaId);
    XLSX.writeFile(wb, tablaId + '.xlsx');
}

function exportarPDF(tablaId, nombreArchivo) {
    const { jsPDF } = window.jspdf;
    let doc = new jsPDF();
    doc.text(nombreArchivo, 10, 10);
    doc.autoTable({ html: `#${tablaId}` });
    doc.save(`${nombreArchivo}.pdf`);
}

function filtrarTablaActiva() {
 /*   // Obtener tabla activa
    const tablaActiva = document.querySelector('.tab-content.active table');
    const filtro = document.getElementById('filtroTabla').value.toLowerCase();
    const filas = tablaActiva.querySelectorAll('tbody tr');

    // Iterar por las filas y aplicar filtro
    filas.forEach(fila => {
        const textoFila = fila.textContent.toLowerCase();
        fila.style.display = textoFila.includes(filtro) ? '' : 'none';
    });
*/
// Obtener tabla activa
const tablaActiva = document.querySelector('.tab-content.active table');
const filtro = document.getElementById('filtroTabla').value.toLowerCase();
const filas = tablaActiva.querySelectorAll('tbody tr');
const headers = Array.from(tablaActiva.querySelectorAll('thead th')).map(th => th.textContent.toLowerCase());

let totalesFiltrados = {};

// Inicializa totales para columnas numéricas
headers.forEach((header, i) => {
    totalesFiltrados[i] = 0;
});

// Iterar por las filas y aplicar filtro
filas.forEach(fila => {
    const textoFila = fila.textContent.toLowerCase();
    const coincide = textoFila.includes(filtro);
    fila.style.display = coincide ? '' : 'none';

    if (coincide) {
        const celdas = fila.querySelectorAll('td');
        celdas.forEach((celda, i) => {
            const valor = parseFloat(celda.textContent.replace(',', '.'));
            if (!isNaN(valor)) {
                totalesFiltrados[i] += valor;
            }
        });
    }
});

// Eliminar fila anterior de totales si existe
const filasTotales = tablaActiva.querySelectorAll('tfoot tr');
filasTotales.forEach(ft => ft.remove());

// Crear fila de totales
let tfoot = tablaActiva.querySelector('tfoot');
if (!tfoot) {
    tfoot = document.createElement('tfoot');
    tablaActiva.appendChild(tfoot);
}

const filaTotal = document.createElement('tr');
headers.forEach((_, i) => {
    const td = document.createElement('td');
    if (totalesFiltrados[i] !== 0) {
        td.textContent = totalesFiltrados[i].toFixed(2);
        td.style.fontWeight = 'bold';
        td.style.backgroundColor = '#f1f1f1';
    } else {
        td.textContent = '';
    }
    filaTotal.appendChild(td);
});
tfoot.appendChild(filaTotal);



}

