<?php

$dsn = "mysql:host=66.70.255.14;dbname=netempir_elpunto;charset=utf8mb4";
$usuario = "netempir_elpunto";
$password = "elpunto2018+-";

try {
    $pdo = new PDO($dsn, $usuario, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos"]);
    exit;
}
if (isset($_REQUEST['cedula'])){$cedula=$_REQUEST['cedula'];}else{$cedula="";}
if (isset($_REQUEST['tipo'])){$tipo=$_REQUEST['tipo'];}else{$tipo="";}
if (isset($_REQUEST['factura'])){$factura=$_REQUEST['factura'];}else{$factura="";}
if (isset($_REQUEST['cliente'])){$cliente=$_REQUEST['cliente'];}else{$cliente="";}




if(trim($tipo)==="gestiones"){
   
    if (!$factura || !$cliente) {
        http_response_code(400);
        echo json_encode(["error" => "Debe proporcionar factura y cliente"]);
        exit;
    }

    // 🔹 Obtener gestiones
    $sql_gestiones = "SELECT nrogst, fchgst, obsgst, vlrpgs AS valor, fchpgs AS fecha_compromiso 
                      FROM actgst 
                      WHERE nriper = :cliente AND nrocmp = :factura";
    
    $stmt_gestiones = $pdo->prepare($sql_gestiones);
    $stmt_gestiones->execute(['cliente' => $cliente, 'factura' => $factura]);
    $gestiones_data = $stmt_gestiones->fetchAll(PDO::FETCH_ASSOC); // 🔹 fetchAll para obtener todas las gestiones

    header('Content-Type: application/json');
    echo json_encode($gestiones_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}else{
    if (!$cedula) {
        http_response_code(400);
        echo json_encode(["error" => "Debe proporcionar una cédula"]);
        exit;
    }
    //header('Content-Type: application/json');
    //echo json_encode(["sino" => 'no da']);
    //exit;
}

// 🔹 1️⃣ Obtener Facturas del Cliente
$sql_cuotas = "
    SELECT 
        nrocmp,
        nriper,
        SUM(vlrqts) AS total_factura,
        SUM(abnqts) AS total_pagado,
        SUM(vlrqts - abnqts) AS saldo_pendiente,
        MAX(fchpgs) AS ultimo_pago
    FROM carqts
    WHERE nriper = :nriper
    GROUP BY nrocmp, nriper;
";
$stmt_cuotas = $pdo->prepare($sql_cuotas);
$stmt_cuotas->execute(['nriper' => $cedula]);
$facturas = $stmt_cuotas->fetchAll(PDO::FETCH_ASSOC);

if (!$facturas) {
    echo json_encode(["error" => "No se encontraron facturas para la cédula proporcionada."]);
    exit;
}

// 🔹 2️⃣ Obtener Nombre del Cliente
$sql_cliente = "SELECT nriper, nomper AS cliente_nombre,telper,celper,emlper FROM actper WHERE nriper = :nriper";
$stmt_cliente = $pdo->prepare($sql_cliente);
$stmt_cliente->execute(['nriper' => $cedula]);
$cliente_data = $stmt_cliente->fetch(PDO::FETCH_ASSOC);
$cliente_nombre = $cliente_data['cliente_nombre'] ?? '';

// 🔹 3️⃣ Obtener Productos por Factura
$sql_productos = "SELECT nrocmp, GROUP_CONCAT(DISTINCT TRIM(dspdcm) ORDER BY dspdcm SEPARATOR ', ') AS productos FROM cardet WHERE codknp IN ('001', '002') and nriper = :nriper GROUP BY nrocmp";
$stmt_productos = $pdo->prepare($sql_productos);
$stmt_productos->execute(['nriper' => $cedula]);
$productos_data = $stmt_productos->fetchAll(PDO::FETCH_ASSOC);
$productos_map = array_column($productos_data, 'productos', 'nrocmp');

// 🔹 4️⃣ Obtener Codeudores (IDs)
$sql_codeudores = "SELECT nrofac AS nrocmp, GROUP_CONCAT(DISTINCT nriper ORDER BY nriper SEPARATOR ', ') AS codeudores_ids FROM carsol WHERE nrisol = :nriper GROUP BY nrofac";
$stmt_codeudores = $pdo->prepare($sql_codeudores);
$stmt_codeudores->execute(['nriper' => $cedula]);
$codeudores_data = $stmt_codeudores->fetchAll(PDO::FETCH_ASSOC);
$codeudores_map = array_column($codeudores_data, 'codeudores_ids', 'nrocmp');

// 🔹 5️⃣ Obtener Nombres de Codeudores
$sql_nombres_codeudores = "SELECT nriper, nomper,telper,celper,emlper FROM actper WHERE nriper IN (SELECT DISTINCT nriper FROM carsol WHERE nrisol = :nriper)";
$stmt_nombres_codeudores = $pdo->prepare($sql_nombres_codeudores);
$stmt_nombres_codeudores->execute(['nriper' => $cedula]);
$nombres_codeudores_data = $stmt_nombres_codeudores->fetchAll(PDO::FETCH_ASSOC);
$nombres_codeudores_map = array_column($nombres_codeudores_data, 'nomper', 'nriper');

$resultado = [];

foreach ($facturas as $factura) {
    $nrocmp = $factura['nrocmp']; // Definir nrocmp correctamente

    // Agregar cada factura con su información
    $resultado[] = [
        'nrocmp'            => $nrocmp,
        'fchcmp'            => $factura['ultimo_pago'], // Tomar la fecha del último pago
        'id_cliente'           => $factura['nriper'],
        'cliente_nombre'    => $cliente_nombre,
        'Valor_factura'           => $factura['total_factura'],
        'Valor_pagado'           => $factura['total_pagado'],
        'saldo_capital'           => $factura['saldo_pendiente'],
        'productos'         => $productos_map[$nrocmp] ?? '', // Manejo seguro de nulos
        'codeudores_ids'    => $codeudores_map[$nrocmp] ?? '', // Manejo seguro de nulos
        'codeudores_nombres'=> isset($codeudores_map[$nrocmp]) 
                                    ? implode(', ', array_map(function ($id) use ($nombres_codeudores_map) {
                                        return $nombres_codeudores_map[$id] ?? '';
                                    }, explode(', ', $codeudores_map[$nrocmp])))
                                    : '' // Manejo de la ausencia de datos
    ];
}

// Imprimir el resultado en formato JSON
header('Content-Type: application/json');
echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
exit;

?>

