use RobRichards\XMLSecLibs\XMLSecurityDSig;
use RobRichards\XMLSecLibs\XMLSecurityKey;

// Cargar el XML a firmar
$doc = new DOMDocument();
$doc->load('ruta/a/tu/documento.xml');

// Crear un nuevo objeto de seguridad
$objDSig = new XMLSecurityDSig('');
$objDSig->setCanonicalMethod(XMLSecurityDSig::EXC_C14N);

// Crear una nueva clave de seguridad (debes tener tu clave privada)
$objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA256, array('type'=>'private'));
$objKey->loadKey('ruta/a/tu/clave_privada.pem', TRUE);

// Firmar el documento
$objDSig->addReference(
    $doc,
    XMLSecurityDSig::SHA256,
    array('http://www.w3.org/2000/09/xmldsig#enveloped-signature'),
    array('force_uri' => true)
);

$objDSig->sign($objKey);

// Agregar la clave pública al documento firmado
$objDSig->add509Cert(file_get_contents('ruta/a/tu/certificado_publico.pem'));

// Anexar la firma al XML
$objDSig->appendSignature($doc->documentElement);

// Guardar el XML firmado
$doc->save('ruta/a/tu/documento_firmado.xml');
