<?php
// Verifica si se ha enviado el parámetro 'folder' a través de la URL
if (isset($_GET['folder']) && !empty($_GET['folder'])) {
    // Sanear la ruta proporcionada por el usuario para evitar problemas de seguridad
    $folderPath = $_GET['folder'];

    // Verifica que la ruta sea válida y exista
    if (is_dir($folderPath)) {
        // Obtiene todos los archivos de la carpeta
        $files = scandir($folderPath);

        // Filtra los archivos para excluir los directorios "." y ".."
        $files = array_diff($files, array('.', '..'));

        // Datos de ejemplo que deseas mostrar (como los usuarios)
        $tableData = [
            ["id" => 1, "name" => "Juan", "age" => 30],
            ["id" => 2, "name" => "Maria", "age" => 25],
        ];

        // Devuelve los datos como JSON
        echo json_encode([
            'tableData' => $tableData,
            'files' => array_values($files) // Asegúrate de que el índice sea numérico
        ]);
    } else {
        echo json_encode(["error" => "La ruta proporcionada no es válida o no existe."]);
    }
} else {
    echo json_encode(["error" => "No se proporcionó la ruta de la carpeta."]);
}
?>
