<?php
    require_once "./pdocontroller.php";

$DBclase = "PDOCONTROLLER";
$DBconex = new $DBclase;
$syseli = " ";

$proyecto = $_REQUEST['proyecto'] ?? "";
$rol      = $_REQUEST['rol'] ?? "";
$codemp   = $_REQUEST['codemp'] ?? "";
$modulo   = $_REQUEST['modulo'] ?? "";

// Ajustar clase según empresa
$DBclase = ($codemp != '' && $codemp != 'dnd') ? "DBC" . $codemp : "DBController";

// Construir la consulta base
$query = "SELECT nommod, titmod, obsmod, link, proyecto, menu, smenu, icono 
          FROM modcmp 
          WHERE (
              proyecto LIKE :proyecto";

// Agregar condición adicional si el proyecto es "Adm" o "Admempire"
$parametros = [":proyecto" => '%' . $proyecto . '%'];

if ($proyecto == "Adm" || $proyecto == "Admempire") {
    $query .= " OR proyecto LIKE :general";
    $parametros[":general"] = '%glb%';
}

$query .= ")";

// Filtrar por empresa si el campo `empresa` no está vacío
$query .= " AND (
                empresa = '' 
                OR FIND_IN_SET(:codemp, empresa) > 0
            )";
$parametros[":codemp"] = $codemp;

// Filtrar por rol si aplica
if ($rol != "" && $rol != "admin") {
    $query .= " AND rol = :rol";
    $parametros[":rol"] = $rol;
}

$query .= " ORDER BY menu, smenu, orden";

// Ejecutar y responder
try {
    $datos = $DBconex->executeconsulta($query, $parametros);
    header("Content-Type: application/json");
    echo json_encode($datos);
    return;
} catch (Exception $ex) {
    echo json_encode(["error" => $ex->getMessage()]);
}

?>

