<?php
$host = 'localhost';
$db = 'mi_base_de_datos';
$user = 'tu_usuario';
$pass = 'tu_contraseña';

$dsn = "mysql:host=$host;dbname=$db;charset=utf8";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $nombre = htmlspecialchars($_POST['nombre'], ENT_QUOTES, 'UTF-8');
        $email = htmlspecialchars($_POST['email'], ENT_QUOTES, 'UTF-8');

        if (isset($_FILES['images']) && $_FILES['images']['error'][0] == 0) {
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            $fileCount = count($_FILES['images']['name']);
            $folderName = uniqid('img_', true);
            $folderPath = 'uploads/' . $folderName;

            if (!is_dir($folderPath)) {
                mkdir($folderPath, 0777, true);
            }

            for ($i = 0; $i < $fileCount; $i++) {
                $fileName = $_FILES['images']['name'][$i];
                $fileTmpName = $_FILES['images']['tmp_name'][$i];
                $fileSize = $_FILES['images']['size'][$i];
                $fileError = $_FILES['images']['error'][$i];
                $fileType = $_FILES['images']['type'][$i];

                $fileExt = strtolower(end(explode('.', $fileName)));
                if (in_array($fileExt, $allowed)) {
                    if ($fileError === 0) {
                        if ($fileSize < 5000000) { // Limitar el tamaño del archivo a 5MB
                            $fileNewName = uniqid('', true) . "." . $fileExt;
                            $fileDestination = $folderPath . '/' . $fileNewName;
                            move_uploaded_file($fileTmpName, $fileDestination);
                        } else {
                            echo "El archivo $fileName es demasiado grande.";
                        }
                    } else {
                        echo "Hubo un error al subir el archivo $fileName.";
                    }
                } else {
                    echo "No se permiten archivos de tipo $fileExt.";
                }
            }

            // Guardar la información en la base de datos
            $stmt = $pdo->prepare('INSERT INTO formulario (nombre, email, ruta_carpeta) VALUES (:nombre, :email, :ruta_carpeta)');
            $stmt->execute([
                'nombre' => $nombre,
                'email' => $email,
                'ruta_carpeta' => $folderName
            ]);

            echo "Imágenes subidas exitosamente en la carpeta: $folderName";
        } else {
            // Guardar la información en la base de datos sin imágenes
            $stmt = $pdo->prepare('INSERT INTO formulario (nombre, email, ruta_carpeta) VALUES (:nombre, :email, :ruta_carpeta)');
            $stmt->execute([
                'nombre' => $nombre,
                'email' => $email,
                'ruta_carpeta' => ''
            ]);

            echo "Formulario enviado sin imágenes.";
        }