<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tabla a JSON</title>
</head>
<body>
    <h1>Tabla de Datos</h1>
    <table border="1" id="tabla">
        <thead>
            <tr>
                <th>Identificación</th>
                <th>Nombres</th>
                <th>Apellidos</th>
                <th>Dirección</th>
                <th>Teléfono</th>
                <th>Email</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Datos de ejemplo, simulando que vienen de una base de datos
            $datos = [
                ["101", "Juan", "Pérez", "Calle 1", "3001234567", "juan.perez@example.com"],
                ["102", "María", "Gómez", "Carrera 2", "3002345678", "maria.gomez@example.com"],
                ["103", "Carlos", "Ramírez", "Avenida 3", "3003456789", "carlos.ramirez@example.com"],
                ["104", "Ana", "Torres", "Calle 4", "3004567890", "ana.torres@example.com"],
                ["105", "Luis", "Martínez", "Carrera 5", "3005678901", "luis.martinez@example.com"],
                ["106", "Sofía", "Hernández", "Avenida 6", "3006789012", "sofia.hernandez@example.com"],
                ["107", "José", "Fernández", "Calle 7", "3007890123", "jose.fernandez@example.com"],
                ["108", "Lucía", "Vargas", "Carrera 8", "3008901234", "lucia.vargas@example.com"],
                ["109", "Andrés", "López", "Avenida 9", "3009012345", "andres.lopez@example.com"],
                ["110", "Laura", "García", "Calle 10", "3000123456", "laura.garcia@example.com"]
            ];

            // Crear filas de la tabla dinámicamente
            foreach ($datos as $fila) {
                echo "<tr>";
                foreach ($fila as $celda) {
                    echo "<td>{$celda}</td>";
                }
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>

    <form method="POST" action="">
        <button type="submit" name="generar_json">Generar JSON</button>
    </form>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generar_json'])) {
        // Crear un arreglo asociativo a partir de los datos
        $jsonArray = [];
        foreach ($datos as $fila) {
            $jsonArray[] = [
                "Identificación" => $fila[0],
                "Nombres" => $fila[1],
                "Apellidos" => $fila[2],
                "Dirección" => $fila[3],
                "Teléfono" => $fila[4],
                "Email" => $fila[5]
            ];
        }

        // Convertir a JSON
        $json = json_encode($jsonArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

        // Establecer las cabeceras para la descarga del archivo
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="datos.json"');
        echo $json;
        exit; // Asegurarse de que no se cargue más contenido
    }
    ?>
</body>
</html>
