    <?php require_once('../TCPDF-main/tcpdf.php');

    // Obtener el número de orden de servicio desde el parámetro GET
    if (isset($_GET['id'])) {
        $no_orden_servicio = $_GET['id'];

        // Consulta SQL para obtener los datos del número de orden de servicio específico
        include('db.php');
        $sql = "SELECT * FROM or_ser WHERE no_orden_servicio = $no_orden_servicio";
        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();

            // Crear un nuevo objeto TCPDF
            $pdf = new TCPDF();

            // Establecer la orientación de la página como apaisada (landscape)
            $pdf->SetPageOrientation('L');

            // Deshabilitar la impresión del encabezado
            $pdf->SetPrintHeader(false);

            // Configurar los márgenes
            $pdf->SetMargins(10, 10, 10, 10);

            // Agregar una página al PDF
            $pdf->AddPage();

            // Contenido HTML de la plantilla
            $html = '
            <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Odontologo</title>
            <style>
                table, td {
                    padding: 5px;
                    border: 1px solid black;
                }
                .logo{
                    width: 50px;
                }
                .tabla_not_bordes ,.tabla_not_bordes td{
                    border: none;
                }
                .td_sin_bordes td{
                    border: none;
                }
                .img-firma{
                    width: 100px;
                }

            </style>
        </head>
            <body>
                <table class="tabla_not_bordes">
                    <tr>
                        <td rowspan="2" style="width: 20%;"><img src="./logo.png" class="logo"></td>
                        <td style="text-align: center; width: 60%;"><h1>U.T. ODON TOMEDIC</h1></td>
                        <td rowspan="2" style="width: 20%; text-align: right;" >EM~EMPIRE®<br> ' . $row["fecha"] . '</td>
                    </tr>
                    <tr>
                        <td style="text-align: center;"><h2>ORDEN DE SERVICIO No: ' . $row["no_orden_servicio"] .'</h2></td>
                    </tr>
                    <tr>
                        <td colspan="3" align="rigth">' . $row["fecha_2"] . '</td>
                    </tr>
                </table>
                <table class="td_sin_bordes">
                    <tr>
                        <td colspan="2"><b>Paciente: </b>' .$row["paciente"] .'</td>
                        <td><b>DOCUMENTO DE IDENTIDAD: </b>' . $row["doc_identidad"] .' </td> 
                    </tr>
                    <tr>
                        <td><b>Empresa: </b>' . $row["empresa"] . '</td>
                        <td><b>Regimen: </b>' . $row["regimen"] . '</td>
                        <td><b>Historia No: </b>' . $row["no_historia"] . '</td>
                    </tr>
                    
                </table>
                <table>
                '<while($row = $result->fetch_assoc()) { '
                    <tr>
                        <td> '.$row["numero_orden"].' - ' .$row["detalle_orden"] .'</td>
                    </tr>
                '}'
                </table>
                <table class="tabla_not_bordes">
                    <tr>
                        <td>
                    
                            <span><img class="img-firma" src="/img/'.$row["img_firma"].'"></span><br>
                            <span>____________________________________</span><br>
                            <span> '. $row["nombre_medico"].'</span><br>
                            <span> N.I: ' . $row["id_medico"] . '</span>
                        </td>
                    </tr>
                </table>


            </body>
        </html>
            ';

            // Insertar el contenido HTML en el PDF
            $pdf->writeHTML($html, true, false, true, false, '');

            // Nombre del archivo PDF
            $filename = 'orden_servicio_' . $no_orden_servicio . '.pdf';

            // Salida del PDF: Descargar el archivo directamente
            $pdf->Output('prueba'); // 'D' (para descargar)
        } else {
            echo "No se encontraron datos para el No. Orden de Servicio: $no_orden_servicio";
        }

        // Cerrar la conexión a la base de datos
        $conn->close();
    } else {
        echo "No se proporcionó un número de orden de servicio válido.";
    }
