<?php
  
  function signSoap($fileName,$xmlFile,$to,$action){
  
    $toId = 'A761BBC7BD3CF85423157738020456023';
    $to = 'https://vpfe.dian.gov.co/WcfDianCustomerServices.svc';
    $digestValue =  $this->getToTagCan($toId,$to);
    $signedInfoTag = $this->getSignedInfoCan($toId,$digestValue);
    $algo = "SHA256";
    openssl_sign($signedInfoTag, $signatureResult, $this->privateKey, $algo);
    $signatureValue = base64_encode($signatureResult);
    $created = gmdate("Y-m-d\TH:i:s\Z" );
    $expires = gmdate("Y-m-d\TH:i:s\Z", time() + 3600 );

    $certificate = $this->getCertificate();
    $signedSoap = $this->formSoapRequest($certificate,$created,$expires,$digestValue,$signatureValue,$action,$to,$fileName,$xmlFile,$toId);

    return $signedSoap;

  }
  // obtener el digest de la etiqueta total
  function getToTagCan($id,$to){
    // etiqueta <to>  canonical
    $to_tag = '<wsa:To xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:wcf="http://wcf.dian.colombia" xmlns:wsa="http://www.w3.org/2005/08/addressing" xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd" wsu:Id="id-'.$id.'">'.$to.'</wsa:To>';    
    $digest = base64_encode(hash('sha256',$to_tag,true));
    return $digest; 
    // es posible dejar este valor 'hard-coded' ya que mientras nada cambie en la etiqueda el valor siempre va a ser el mismo 
  }

  function getSignedInfoCan($id,$digestValue){

    // <SignedInfo> canonical
    return '<ds:SignedInfo xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:wcf="http://wcf.dian.colombia" xmlns:wsa="http://www.w3.org/2005/08/addressing"><ds:CanonicalizationMethod Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"><ec:InclusiveNamespaces xmlns:ec="http://www.w3.org/2001/10/xml-exc-c14n#" PrefixList="wsa soap wcf"></ec:InclusiveNamespaces></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"></ds:SignatureMethod><ds:Reference URI="#id-'.$id.'"><ds:Transforms><ds:Transform Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"><ec:InclusiveNamespaces xmlns:ec="http://www.w3.org/2001/10/xml-exc-c14n#" PrefixList="soap wcf"></ec:InclusiveNamespaces></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256"></ds:DigestMethod><ds:DigestValue>'.$digestValue.'</ds:DigestValue></ds:Reference></ds:SignedInfo>';


  }

  function formSoapRequest($certificate,$created,$expires,$disgestValue,$signatureValue,$action,$to,$fileName,$xmlFile,$toId){
    return  '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:wcf="http://wcf.dian.colombia"><soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing"><wsse:Security xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"><wsse:BinarySecurityToken EncodingType="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary" ValueType="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3" wsu:Id="X509-'.$toId.'">'.$certificate.'</wsse:BinarySecurityToken><wsu:Timestamp><wsu:Created>'.$created.'</wsu:Created><wsu:Expires>'.$expires.'</wsu:Expires></wsu:Timestamp><ds:Signature xmlns:ds="http://www.w3.org/2000/09/xmldsig#"><ds:SignedInfo><ds:CanonicalizationMethod Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"><ec:InclusiveNamespaces PrefixList="wsa soap wcf" xmlns:ec="http://www.w3.org/2001/10/xml-exc-c14n#"/></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"/><ds:Reference URI="#id-'.$toId.'"><ds:Transforms><ds:Transform Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"><ec:InclusiveNamespaces PrefixList="soap wcf" xmlns:ec="http://www.w3.org/2001/10/xml-exc-c14n#"/></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256"/><ds:DigestValue>'.$disgestValue.'</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue>'.$signatureValue.'</ds:SignatureValue><ds:KeyInfo><wsse:SecurityTokenReference><wsse:Reference URI="#X509-'.$toId.'" ValueType="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3"/></wsse:SecurityTokenReference></ds:KeyInfo></ds:Signature></wsse:Security><wsa:Action>'.$action.'</wsa:Action><wsa:To wsu:Id="id-'.$toId.'" xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd">'.$to.'</wsa:To></soap:Header><soap:Body><wcf:SendBillSync><wcf:fileName>'.$fileName.'</wcf:fileName><wcf:contentFile>'.$xmlFile.'</wcf:contentFile></wcf:SendBillSync></soap:Body></soap:Envelope>';
  }
