<?php
require_once('./TCPDF-main/tcpdf.php');

// Obtener el contenido del archivo HTML
$html = file_get_contents('template.php');

// Crear una instancia de TCPDF con un tamaño de página personalizado
$pageWidth = 65; // Ancho de la página en mm
$pageHeight = 350; // Alto de la página en mm
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, array($pageWidth, $pageHeight), true, 'UTF-8', false);

// Establecer la información del documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nombre del Autor');
$pdf->SetTitle('Factura POS');
$pdf->SetSubject('Factura de Venta');
$pdf->SetKeywords('TCPDF, PDF, factura, POS');

// Eliminar el encabezado y el pie de página predeterminados
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Establecer los márgenes a 0
$pdf->SetMargins(2, 2, 2);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);

// Agregar una página
$pdf->AddPage();

// Establecer la fuente
$pdf->SetFont('helvetica', '', 10);

// Escribir el contenido HTML en el PDF
$pdf->writeHTML($html, true, false, true, false, '');

// Generar el PDF y forzar la descarga
$pdf->Output('factura_pos.pdf', 'D');
?>
